/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.java.truevfs.comp.zip.CheckedInputStreamWithSkipBufferSize;
import net.java.truevfs.comp.zip.Crc32Exception;
import net.java.truevfs.comp.zip.ZipEntry;

final class Crc32InputStream
extends CheckedInputStreamWithSkipBufferSize {
    private final ZipEntry entry;
    private boolean closed;

    Crc32InputStream(InputStream in, int skipBufferSize, ZipEntry entry) {
        super(in, new CRC32(), skipBufferSize);
        this.entry = entry;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            while (this.skip(Long.MAX_VALUE) > 0L) {
            }
        }
        super.close();
        this.closed = true;
        long expected = this.entry.getCrc();
        long computed = this.getChecksum().getValue();
        if (expected != computed) {
            throw new Crc32Exception(this.entry.getName(), expected, computed);
        }
    }
}

